<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('requisition_retirement', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cash_requisition_id')->constrained()->onDelete('cascade');
           
            $table->json('usage_details');
            $table->json('receipts')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('requisition_retirement');
    }
};