<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('work_centers', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('location');
          //  $table->enum('capacity_per_day_uom', ['units', 'hours'])->default('units');
            //$table->decimal('capacity_per_day', 8, 2);
            $table->timestamps();
        });
     
        Schema::create('work_center_capacity_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('work_center_id')->constrained('work_centers')->onDelete('cascade');
            $table->date("log_date");
            $table->decimal('utilized_capacity', 8, 2);//hours or units
            $table->decimal('available_capacity', 8, 2);//hours or units
            $table->string('description')->nullable();
            $table->timestamps();
        });
        Schema::create('work_center_downtime_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('work_center_id')->constrained('work_centers')->onDelete('cascade');
            $table->string("downtime_reason");
            $table->date("start_time");
            $table->date("end_time")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('work_centers');
        Schema::dropIfExists('capacity_logs');
    }
};
/*
Inventory Management: Handling raw materials (items).
Bill of Materials (BOM): Defining components for each product.
Production Planning: Scheduling production tasks.
Work Orders: Managing production activities.
Quality Control: Ensuring the final product meets standards.
Finished Goods Inventory: Storing completed products.

Process Flow Breakdown:
Inventory Management (Raw Materials/Items):

Trigger: Stock Replenishment or Production Demand.
Input: Raw materials from suppliers.
Output: Raw materials stored in inventory.
Decision Point: Check if reorder level is reached → Generate Purchase Order (optional).
Bill of Materials (BOM):

Trigger: Product design/creation.
Input: List of items needed to manufacture a product.
Output: Detailed BOM saved to the system, associating items with a product.
Production Planning:

Trigger: Customer order or internal production forecast.
Input: BOM for the product, available inventory of items.
Output: Production plan created (including scheduling, work orders, and capacity planning).
Work Order Creation:

Trigger: Approved production plan.
Input: Work orders specifying tasks, required materials, and labor.
Output: Work orders initiated to start manufacturing.
Production Execution:

Trigger: Work orders.
Input: Raw materials and labor.
Output: Finished or semi-finished goods.
Decision Point: Pass/Fail Quality Control check.
Quality Control (QC):

Trigger: Completion of manufacturing.
Input: Finished goods from production.
Output: Approved goods moved to finished goods inventory or rejected goods for rework.
Finished Goods Inventory:

Trigger: Passed QC.
Input: Finished products.
Output: Products stored in finished goods inventory and ready for shipment or sale.
Diagram Structure


          +---------------------------------+
          |         Raw Materials           |
          |         (Inventory)             |
          +---------------------------------+
                     |                          
                     v                          
          +---------------------------------+
          |         Bill of Materials       |
          +---------------------------------+
                     |                          
                     v                          
          +---------------------------------+
          |      Production Planning        |
          +---------------------------------+
                     |                          
                     v                          
          +---------------------------------+
          |      Work Order Creation        |
          +---------------------------------+
                     |                          
                     v                          
          +---------------------------------+
          |     Production Execution        |
          +---------------------------------+
                     |                          
                     v                          
          +---------------------------------+
          |       Quality Control           |
          +---------------------------------+
                     |                          
             +-------+-------+                
             |               |                
             v               v                
      +------------+   +-------------+        
      |  Rejected  |   |  Approved   |        
      |  Goods     |   |  Goods      |        
      +------------+   +-------------+        
             |               |                
             v               v                
      +-------------------------------+       
      |   Rework or Scrap Process      |       
      +-------------------------------+       
                     |
                     v
           +----------------------------+
           | Finished Goods Inventory    |
           +----------------------------+

*/
