<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bill_of_materials', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->foreignId("branch_id")->nullable();
            $table->foreignId("item_id")->constrained("items",'id');
            $table->string('version')->nullable();
            $table->timestamps();
        });
        Schema::create('bill_of_material_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bill_of_material_id')->constrained('bill_of_materials')->onDelete('cascade');
            $table->foreignId('raw_material_id')->constrained('items')->onDelete('cascade');
            $table->decimal('quantity', 8, 2);
            $table->string('unit_of_measurement');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bill_of_materials');
        Schema::dropIfExists('bill_of_material_items');
    }
};
