<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('machines', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string('name');
            $table->foreignId('work_center_id')->constrained('work_centers')->onDelete('cascade');
            $table->integer('maintenance_every_after')->default(0);
            $table->enum('maintenance_period', ['day','month', 'year'])->default('month');
            $table->enum('status', ['running', 'maintenance', 'idle'])->default('idle');
            $table->string('model')->nullable();
            $table->string('serial_number')->nullable();
            $table->integer('capacity_per_hour')->nullable(); // Units per hour
            $table->timestamps(); // created_at and updated_at timestamps
        });
        Schema::create('machine_maintenance_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('machine_id')->constrained('machines')->onDelete('cascade');
            $table->date('maintenance_date');
            $table->date('maintenance_end_date')->nullable();
            $table->foreignId('performed_by');
            $table->string('description')->nullable();
            $table->enum('status', ['completed', 'pending', 'in-progress'])->default('pending');
            $table->timestamps(); // created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('machines');
        Schema::dropIfExists('machine_maintenance_logs');
    }
};
