<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inspections', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->foreignId('worker_order_id')->constrained('work_orders')->onDelete('cascade');
            $table->date('inspection_date');
            $table->enum('status', ['passed', 'fail', 'completed']);
            $table->string("remarks")->nullable();
            $table->timestamps();
            
        });
        Schema::create('inspection_cretaria', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
        });
        Schema::create('inspection_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('inspection_id')->constrained('inspections')->onDelete('cascade');
            $table->foreignId('inspection_cretaria_id')->constrained('inspection_cretaria')->onDelete('cascade');
            $table->string('result');
            $table->string("remarks")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inspections');
        Schema::dropIfExists('inspection_cretaria');
        Schema::dropIfExists('inspection_results');
    }
};
