<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('production_processings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('work_order_id')->constrained("work_orders");
            $table->foreignId('item_id')->constrained("items");
            $table->decimal('quantity', 10,2);
            $table->enum('stage', ['raw','semi_finished','final']);
            $table->timestamp('start_time')->nullable();
            $table->timestamp('end_time')->nullable();
            $table->enum('status', ['pending', 'in_progress', 'completed'])->default('pending');
            $table->text('description')->nullable();
            $table->timestamps();
        });
       
    }

    public function down(): void
    {
        Schema::dropIfExists('production_processings');
    }
};
