<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('production_outputs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('production_processing_id')->constrained("production_processings");
            $table->foreignId('item_id')->constrained("items");
            $table->decimal('quantity', 10,2);
            $table->date('production_date');
            $table->enum('status', ['pending', 'completed', 'failed'])->default('pending');
            $table->text('description')->nullable();
            $table->timestamps();
        });
       
    }

    public function down(): void
    {
        Schema::dropIfExists('production_outputs');
    }
};
