<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('request_for_quotation_suppliers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('request_for_quotation_id')->constrained("request_for_quotations");
            $table->foreignId('supplier_id')->constrained("suppliers");
            $table->datetime('invited_at');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('request_for_quotation_suppliers');
    }
};