<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('item_variants', function (Blueprint $table) {
            $table->id(); 
            $table->unsignedBigInteger('item_id'); // Foreign key to the items table
            $table->string('sku')->unique()->nullable(); // Stock Keeping Unit (optional)
            $table->decimal('price', 10, 2)->nullable(); // Price for this variant (optional)
            $table->integer('stock')->default(0); // Stock quantity for this variant
            $table->json('attributes')->nullable(); // Additional attributes (e.g., color, size)
            $table->timestamps();
            // Foreign key constraint
            $table->foreign('item_id')->references('id')->on('items')->onDelete('cascade');
            
        });
        Schema::create('item_variant_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_variant_id')->constrained()->onDelete('cascade');
            $table->string('image_url');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_variants');
        Schema::dropIfExists('item_variant_images');
    }
};
