<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_partners', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained("projects");
            $table->foreignId('partner_id')->constrained("partners");
            $table->enum('type', ['Sponsor', 'Manager', 'Client', 'Contractor', 'Consultant', 'Supplier', 'Team Member', 'Regulatory Body', 'Investor', 'Strategic Partner', 'Community Stakeholder']);
            $table->text('role')->nullable();
            $table->unique(['partner_id','project_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_partners');
    }
};
