<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id');
            $table->string('name');
            $table->text('objectives')->nullable();
            $table->text('activity_methodology')->nullable();
            $table->text('description')->nullable();
            $table->decimal('cost', 20,2)->nullable();
            $table->foreignId('currency_id')->nullable()->constrained("currencies");
            $table->enum("prioty", ['High', 'Medium', 'Low'])->default('Low');
            $table->enum("status", ['Not Started', 'In Progress', 'Completed', 'On Hold', 'Cancelled'])->default('Not Started');
            $table->datetime('start_date');
            $table->datetime('end_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activities');
    }
};
