<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_orders', function (Blueprint $table) {
            $table->id();
            $table->string('sale_order_no');
            $table->uuid('organisation_id');
            $table->uuid('customer_id');  
            $table->date("order_date");    
            $table->foreignId('quotation_id')->nullable()->constrained("quotations"); 
            $table->date("expected_delivery_date")->nullable();    
            $table->decimal('total_amount', 20,2)->default(0);
            $table->enum('status',['pending', 'confirmed', 'shipped', 'completed', 'cancelled'])->default('pending');
            $table->string("delivery_method")->nullable();
            $table->foreignId("sales_person")->nullable()->constrained("employees");
            $table->string("order_note")->nullable();    
            $table->string("terms_and_conditions")->nullable();    
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('customer_id')->references('id')->on('customers')->cascadeOnDelete();
        });
        Schema::create('sales_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_order_id')->constrained("sales_orders");
            $table->foreignId('item_id')->constrained("items");
            $table->integer('quantity');
            $table->decimal('unit_price',20,2);
            $table->decimal('tax',20,2)->default(0);
            $table->decimal('total_price', 20,2)->storedAs('quantity * unit_price');
            $table->foreignId('currency_id')->constrained('currencies');
            $table->string('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
        Schema::create('sales_order_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_order_id')->constrained('sales_orders')->onDelete('cascade');
            $table->foreignId('service_id')->constrained('services');
            $table->foreignId('unit_of_measure_id')->constrained('unit_of_measures');
            $table->decimal('unit_price', 20, 2)->nullable();
            $table->integer('quantity')->nullable();
            $table->decimal('total_cost', 20, 2)->storedAs('unit_price * quantity');
            $table->foreignId('currency_id')->constrained("currencies");
            $table->timestamps();
        });
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string("package_no");
            $table->foreignId('sales_order_id')->constrained('sales_orders')->onDelete('cascade');
            $table->date('package_date');
            $table->string('notes');
            $table->timestamps();
        });
        Schema::create('shipmenet', function (Blueprint $table) {
            $table->id();
            $table->string('shipment_no');
            $table->string('trucking_no');
            $table->string('trucking_url');
            $table->text('sales_orders');
            $table->text('packages');
            $table->date('shipment_date');
            $table->foreignId('truck_id')->constrained("trucks");
            $table->foreignId('driver_id')->constrained("drivers");
            $table->decimal('shipping_charges')->nullable();
            $table->string('notes');
            $table->date('datetime_delivered')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_orders');
        Schema::dropIfExists('sales_order_items');
        Schema::dropIfExists('sales_order_services');
    }
};
