<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('distribution_orders', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->foreignId('sales_order_id')->constrained("sales_orders");
            $table->foreignId('warehouse_id')->constrained('warehouses');
            $table->enum('status',['pending','shipped', 'delivered','returned'])->default('pending');
            $table->date('shipping_date');
            $table->string('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
     
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('distribution_orders');
    }
};
