<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('goods_dispatched_notes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_order_id')->constrained("sales_orders");
            $table->foreignId('distribution_order_id')->nullable();
            $table->foreignId('departure_warehouse_id')->constrained("warehouses", "id");
            $table->string('dispatched_by');
            $table->foreignId('truck_id')->nullable();
            $table->foreignId('driver_id')->nullable();
            $table->string('destination')->nullable();
            $table->date('dispatched_date');
            $table->time('expected_arrival_time')->nullable();
            $table->enum('status',['in-transit','delivered','returned','cancelled'])->default('in-transit');
            $table->text('comment')->nullable();
            $table->timestamps();
        });
        Schema::create('goods_dispatched_note_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('goods_dispatched_note_id')->constrained("goods_dispatched_notes");
            $table->foreignId('item_id')->constrained("sales_order_items", "item_id");
            $table->integer('quantity');
            $table->timestamps();
            $table->softDeletes();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('goods_dispatched_notes');
        Schema::dropIfExists('goods_dispatched_note_items');
    }
};
