<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLetterOfCreditsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('letter_of_credits', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');//->constrained('organisations');
            $table->foreignId('sales_order_id')->constrained('sales_orders');
            $table->foreignId('issuing_bank_id');//->constrained('customer_orders');
            $table->string('lc_number')->unique(); //->constrained('customer_orders');
            $table->decimal('amount', 10, 2); // Amount guaranteed by the LC
            $table->date('issue_date'); // Date the LC was issued
            $table->date('expiry_date'); // Expiry date of the LC
            $table->enum('status',["open", "closed", "expired"])->default('open'); // Status: open, closed, expired
            $table->text('attachments')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('letter_of_credits');
    }
}
